//Price Elasticity Of Demand
//OS:Windows 10
//Scilab 5.5.2

clear;
clc;
close;

//Concept Information
//Formula= % Change in Demand/% Change in Price
//Ed =  (ΔQ/ΔP) * (Po/Qo)
//ΔQ is the Change in Quantity [Q0-Q1] (or) Initial Quantity - Final Quantity
//ΔP is the Change in Price [P0-P1] (or) Initial Price - Final Price
//Q0 stands for Quantity for previous

//Type 1
//Given
P0=8       //in rupees
P1=4      //in rupees
Q0=10     //in units
Q1=12     //in units

//Solution
Ed=((Q0-Q1)/(P0-P1)*(P0/Q0))

//Values
mprintf("   Px(in rupees)     Dx(in units)")
mprintf("\n     %d\t\t\t%d",P0,Q0)
mprintf("\n     %d\t\t\t%d",P1,Q1)

//Result
//Note: -ve sign is ignored
mprintf("\n   Ed:%f",-Ed)
if -Ed < 1 then
    mprintf("\nLess than Elasticity Of Demand")
else
    mprintf("Greater than Elasticity Of Demand")
end

//Type 2
//Given
P0=8       //in rupees
P1=6      //in rupees
Q0=10     //in units
Q1=25     //in units

Ed=((Q0-Q1)/(P0-P1)*(P0/Q0))

//Values
mprintf("\n\n   Px(in rupees)     Dx(in units)")
mprintf("\n     %d\t\t\t%d",P0,Q0)
mprintf("\n     %d\t\t\t%d",P1,Q1)

//Result
//Note: -ve sign is ignored
mprintf("\n   Ed:%d",-Ed)
if -Ed < 1 then
    mprintf("\nLess than Elasticity Of Demand")
else
    mprintf("\nGreater than Elasticity Of Demand")
end

//Output
//    Px(in rupees)     Dx(in units)
//     8			10
//     4			12
//   Ed:0.400000
//Less than Elasticity Of Demand
//
//   Px(in rupees)     Dx(in units)
//     8			10
//     6			25
//   Ed:6
// Greater than Elasticity Of Demand
